//
//  exifGeometry.m
//  HelloWorld
//
//  Created by Erica Sadun on 7/18/11.
//  Copyright 2011 Up To No Good, Inc. All rights reserved.
//

#import "exifGeometry.h"

/*
 enum {
 kTopLeft			= 1, // UIImageOrientationUp,           (0,0) w lewym górnym rogu
 kTopRight           = 2, // UIImageOrientationUpMirrored,   (0,0) w prawym górnym rogu
 kBottomRight        = 3, // UIImageOrientationDown          (0,0) w prawym dolnym rogu
 kBottomLeft         = 4, // UIImageOrientationDownMirrored  (0,0) w lewym dolnym rogu
 kLeftTop            = 5, // UIImageOrientationLeftMirrored  (0,0) w lewym górnym rogu
 kRightTop           = 6, // UIImageOrientationLeft          (0,0) w prawym górnym rogu
 kRightBottom        = 7, // UIImageOrientationRightMirrored (0,0) w prawym dolnym rogu
 kLeftBottom         = 8  // UIImageOrientationRight         (0,0) w lewym dolnym rogu
 } ExifOrientation;
 
 góra, lewo   góra, prawo   dół, prawo   dół, lewo    lewo, góra   prawo, góra   prawo, dół   lewo, dół
 EXIF 1       2             3            4            5            6             7            8
 
 XXXXXX  XXXXXX      XX  XX      XXXXXXXXXX  XX                  XX  XXXXXXXXXX
 XX          XX      XX  XX      XX  XX      XX  XX          XX  XX      XX  XX
 XXXX      XXXX    XXXX  XXXX    XX          XXXXXXXXXX  XXXXXXXXXX          XX
 XX          XX      XX  XX
 XX          XX  XXXXXX  XXXXXX
 
 UI 0        4               1       5               6             2        7              3
 w górę   odbicie w górę  w dół   odbicie w dół   lewe odbicie  w lewo   prawe odbicie  w prawo

*/

CGPoint pointInEXIF(ExifOrientation exif, CGPoint aPoint, CGRect rect)
{
    switch(exif)
    {
        case kTopLeft: // sprawdzone - tył -- NIE DLA PRZEDNIEJ
            return CGPointMake(aPoint.x, rect.size.height - aPoint.y);
        case kTopRight: 
            return CGPointMake(rect.size.width - aPoint.x, rect.size.height - aPoint.y);
        case kBottomRight: // sprawdzone - tył
            return CGPointMake(rect.size.width - aPoint.x, aPoint.y);
        case kBottomLeft:
            return CGPointMake(aPoint.x, aPoint.y);

        case kLeftTop: // sprawdzone - tylko tył -- NIE DLA PRZEDNIEJ
            return CGPointMake(aPoint.y, aPoint.x);
        case kRightTop: // niesprawdzone
            return CGPointMake(aPoint.y, aPoint.x);
        case kRightBottom: // sprawdzone - tył
            return CGPointMake(rect.size.width - aPoint.y, rect.size.height - aPoint.x);
        case kLeftBottom: // niesprawdzone
            return CGPointMake(rect.size.width - aPoint.y, rect.size.height - aPoint.x);
    }
}

CGSize sizeInEXIF(ExifOrientation exif, CGSize aSize)
{
    switch(exif)
    {
        case kTopLeft:
        case kTopRight:
        case kBottomRight:
        case kBottomLeft:
            return aSize;
            
        case kLeftTop:
        case kRightTop:
        case kRightBottom:
        case kLeftBottom:
            return CGSizeMake(aSize.height, aSize.width);
    }
}

CGRect rectInEXIF(ExifOrientation exif, CGRect inner, CGRect outer)
{
    CGRect rect;
    rect.origin = pointInEXIF(exif, inner.origin, outer);
    rect.size = sizeInEXIF(exif, inner.size);
    
    switch(exif)
    {
        case kTopLeft: // sprawdzone
            rect = CGRectOffset(rect, 0.0f, -inner.size.height);
            break;
        case kTopRight: // sprawdzone
            rect = CGRectOffset(rect, -inner.size.width, -inner.size.height);
            break;
        case kBottomRight: // sprawdzone
            rect = CGRectOffset(rect, -inner.size.width, 0.0f);
            break;
        case kBottomLeft: // sprawdzone
            break;
        case kLeftTop: // sprawdzone 
            break;
        case kRightTop: // niesprawdzone
            break;
        case kRightBottom: // sprawdzone na tylnej, NIE DLA PRZEDNIEJ
            rect = CGRectOffset(rect, -inner.size.width, -inner.size.height);
            break;
        case kLeftBottom: // niesprawdzone
            break;
    }
    
    return rect;
}